<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Merchant extends Model 
{

    protected $table = 'merchants';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'phone', 'Identification_number', 'birth_date', 'work_type', 'salary', 'obligations', 'profit_rate', 'maximum_repayment_period', 'minmum_repayment_period', 'profit_percentage', 'ability_to_notify');

    public function transactions()
    {
        return $this->hasMany('App\Models\Merchant');
    }

    public function notifications()
    {
        return $this->morphMany('App\Models\Merchant', '"notificationable"');
    }

}